<?php


require_once('config.php');





if(($response["error"] == true))
{
    echo(json_encode($response));
}

if(($response["error"] == false))
{
    if((isset($_POST["request"])) && ($_POST["request"] == "get_products_home"))
    {
        $records        =   array();
        $sql            =   "   SELECT M.id ID, M.title TITLE, M.description DESCRIPTION, M.category_id CATEGORY_ID, C.category_name CATEGORY_NAME, 
                                M.price PRICE, M.discount_price DISCOUNT_PRICE, M.product_status PRODUCT_STATUS, M.register_on REGISTER_ON, 
                                M.quantity QUANTITY, D.image_name IMAGE, REPLACE(LOWER(M.title), ' ', '-') PRODUCT_KEYWORD, 
                                REPLACE(LOWER(C.category_name), ' ', '-') CATEGORY_KEYWORD 
                                FROM product_mst M, product_images D, category C
                                WHERE M.id = D.product_mst_id
                                AND M.category_id = C.id
                                AND D.primary_image = 'Y'
                                AND D.image_name != ''
                                LIMIT 16";
        $stmt = $db->prepare($sql); 
        $stmt->execute();
        $result     =   $stmt->get_result();
        while($row = mysqli_fetch_assoc($result))
        {
            $records[]   =   $row;
        }

        if((count($records) === 0))
        {
            $html   =   '<p>No Product found in the system</p>';
        }
        else
        {
            $html   =   '';
            foreach($records as $k => $v)
            {
                $html  .=   '<div class="col-lg-3">';
                $html  .=   '<div class="post-item position-relative h-100" data-aos="fade-up" data-aos-delay="100">';
                $html  .=   '<div class="post-img position-relative overflow-hidden">';
                $html  .=   '<img src="'.$base_url.'uploads/products/'.$v["IMAGE"].'" class="img-fluid" alt="'.$v["PRODUCT_KEYWORD"].'">';
                $html  .=   '<span class="post-date">NEW ARRIVALS</span>';
                $html  .=   '</div>';
                $html  .=   '<div class="post-content d-flex flex-column">';
                $html  .=   '<h3 class="post-title">'.$v["TITLE"].'</h3>';
                $html  .=   '<p style="color: #f0474e; font-weight: 600;">'.$v["PRICE"].' £</p>';
                $html  .=   '<hr>';
                $html  .=   '<a href="'.$base_url.'product?title='.$v["PRODUCT_KEYWORD"].'" class="readmore stretched-link"><span>Shop Now</span><i class="bi bi-arrow-right"></i></a>';
                $html  .=   '</div>';
                $html  .=   '</div>';
                $html  .=   '</div>';
            }
            $response["html"]    =  $html;
        }
        echo(json_encode($response));
    }



    if((isset($_POST["request"])) && ($_POST["request"] == "get_shop_products"))
    {
        $params                 =   "";
        $records_count          =   "";
        $offset                 =   "";
        $current_page           =   "";
        $pagination_start_page  =   "";
        $pagination_end_page    =   "";

        if((!isset($_POST["params"])) || (empty($_POST["params"])))
        {
            $params     =   array();
        }
        else
        {
            $json       =   json_decode($_POST["params"], true);
            $params     =   (array) $json;
            
        }

        if((!isset($params["LIMIT"])) || (empty($params["LIMIT"])))
        {
            $page_limit     =   30;
        }
        else
        {
            $page_limit     =   intval($params["LIMIT"]);
        }

        $sql    =   "   SELECT COUNT(*) RECORDS_COUNT  FROM product_mst M, product_images D, category C
                        WHERE M.id = D.product_mst_id
                        AND M.category_id = C.id
                        AND D.primary_image = 'Y'
                        AND D.image_name != '' ";
        $stmt = $db->prepare($sql); 
        $stmt->execute();
        $result     =   $stmt->get_result();
        if(($result))
        {
            $row = mysqli_fetch_assoc($result);
            if(($row))
            {
                $records_count  =   intval($row["RECORDS_COUNT"]);
            }
            else
            {
                $response["error"]      =   true;
                $response["error_msg"]  =   "An Error Occurred. There are no products found in the system";
            }
        }
        else
        {
            $response["error"]      =   true;
            $response["error_msg"]  =   "An Error Occurred. There are no products found in the system";
        }

        $records        =   array();
        $sql            =   "   SELECT M.id ID, M.title TITLE, M.description DESCRIPTION, M.category_id CATEGORY_ID, C.category_name CATEGORY_NAME, 
                                M.price PRICE, M.discount_price DISCOUNT_PRICE, M.product_status PRODUCT_STATUS, M.register_on REGISTER_ON, 
                                M.quantity QUANTITY, D.image_name IMAGE, REPLACE(LOWER(M.title), ' ', '-') PRODUCT_KEYWORD, 
                                REPLACE(LOWER(C.category_name), ' ', '-') CATEGORY_KEYWORD 
                                FROM product_mst M, product_images D, category C
                                WHERE M.id = D.product_mst_id
                                AND M.category_id = C.id
                                AND D.primary_image = 'Y'
                                AND D.image_name != ''";

        if(($params["LIMIT"]) && (!empty($params["LIMIT"])))
        {
            $sql    .=  ' LIMIT '.$params["LIMIT"].'  ';
        }
        if((isset($params["PAGE"])))
        {
            if(($params["PAGE"] > 4))
            {
                $current_page           =       intval($params["PAGE"]);
                $pagination_start_page  =       $current_page - 3;
                $pagination_end_page    =       $current_page + 5;
                $offset                 =   round(($params["PAGE"] * $page_limit));
                $sql                   .=      ' OFFSET '.$offset.'  ';
            }
            else
            {
                $current_page           =       intval($params["PAGE"]);
                $pagination_start_page  =       1;
                $pagination_end_page    =       10;
                $offset                 =       round(($params["PAGE"] * $page_limit));
                $sql                   .=      ' OFFSET '.$offset.'  ';
            }
        }
        
        $stmt = $db->prepare($sql); 
        $stmt->execute();
        $result     =   $stmt->get_result();
        while($row = mysqli_fetch_assoc($result))
        {
            $records[]   =   $row;
        }


        if(($response["error"] == false))
        {
            $html   =   '';
            foreach($records as $k => $v)
            {
                $html  .=   '<div class="col-lg-3">';
                $html  .=   '<div class="card">';
                $html  .=   '<div class="card-body" style="height: 300px; max-height: 300px">';
                $html  .=   '<a href="'.$base_url.'product?title='.$v["PRODUCT_KEYWORD"].'"><img src="'.$base_url.'uploads/products/'.$v["IMAGE"].'" class="img-fluid" alt="'.$v["TITLE"].'" /></a>';
                $html  .=   '<a href="'.$base_url.'product?title='.$v["PRODUCT_KEYWORD"].'"><h4 style="font-size: 14px; margin-top: 10px; font-weight: 600">'.$v["TITLE"].'</h4></a>';
                $html  .=   '<p style="font-size: 18px; color: #ed1b24; font-weight: 500">'.$v["PRICE"].' £ </p>';
                $html  .=   '<a href="'.$base_url.'product?title='.$v["PRODUCT_KEYWORD"].'" class="btn" style="font-size: 14px;font-weight: 500; background-color: #ed1b24; color: white">Shop Now</a>';
                $html  .=   '</div>';
                $html  .=   '</div>';
                $html  .=   '</div>';
            }
            $response["html"]    =  $html;
        }

        if(($response["error"] == false))
        {
            $no_of_pages    =   round(($records_count/$page_limit));

            if(($no_of_pages))
            {
                $html       =   '<div class="row">';
                $html      .=   '<div class="col-lg-12">';
                $html      .=   '<nav aria-label="Page navigation example">';
                $html      .=   '<ul class="pagination justify-content-end">';
                $html      .=   '<li class="page-item disabled">';
                $html      .=   '<a class="page-link">Previous</a>';
                $html      .=   '</li>';
                for($i = $pagination_start_page; $i <= $pagination_end_page; $i ++)
                {
                    $html      .=   '<li class="page-item"><a class="page-link" href="'.$base_url.'/shop?page='.$i.'">'.$i.'</a></li>';
                }
                $html      .=   '<li class="page-item">';
                $html      .=   '<a class="page-link" href="#">Next</a>';
                $html      .=   '</li>';
                $html      .=   '</ul>';
                $html      .=   '</nav>';
                $html      .=   '</div>';
                $html      .=   '</div>';
                $response["pagination"]     =   $html;
            }

        }
        $response["PAGE"]   =   $current_page;
        echo(json_encode($response));
    }

}












































?>