
function getShopProducts(params)
{
    var data = new FormData();
    data.append("request", "get_shop_products");
    data.append("params", JSON.stringify(params));
    $.ajax
    ({
        type: "POST",
        enctype: 'multipart/form-data',
        url: "../controllers/products_shop.php",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 600000,
        async: false,
        success: function (response) 
        {
            response    =   JSON.parse(response);
            if((response["html"]))
            {
                $("#ProductsWrapper").html('');
                $("#ProductsWrapper").html(response["html"]);
            }
            if((response["pagination"]))
            {
                $("#PaginationWrapper").html('');
                $("#PaginationWrapper").html(response["pagination"]);
            }
        },
        error: function (e) 
        {
            console.log("ERROR : ", e);
        }
    });
}


function getCategories()
{
    var data = new FormData();
    data.append("request", "get_categories");
    $.ajax
    ({
        type: "POST",
        enctype: 'multipart/form-data',
        url: "../controllers/categories_shop.php",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 600000,
        async: false,
        success: function (response) 
        {
            response    =   JSON.parse(response);
            if((response["html"]))
            {
                $("#SidebarCategories").html('');
                $("#SidebarCategories").html(response["html"]);
                $("#applybtn").on("click", function(event)
                {
                    var categories  =   [];
                    var inputs  =   $(".CI");
                    $.each(inputs, function(k, v)
                    {
                        if(($(v).is(":checked")) == true)
                        {
                            categories.push($(v).val());   
                        }
                    });
                    window.location.href    =   base_url + "shop?category=" + categories;
                });

            }
        },
        error: function (e) 
        {
            console.log("ERROR : ", e);
        }
    });
}





$(document).ready(function()
{
    getCategories();
    var params  =   {};
    var urlParams = new URLSearchParams(window.location.search);
    if((urlParams.has('category')))
    {
        params["CATEGORY"]  =   urlParams.get('category');
    }
    else
    {
        params["CATEGORY"]  =   "";
    }

    if((urlParams.has('limit')))
    {
        params["LIMIT"]  =   urlParams.get('limit');
    }
    else
    {
        params["LIMIT"]  =   24;
    }
    if((urlParams.has('page')))
    {
        params["PAGE"]  =   urlParams.get('page');
    }
    else
    {
        params["PAGE"]  =   0;
    }
    getShopProducts(params);


});