




function getCategoriesList()
{
    var data    =   new FormData();
    data.append("request", "get_categories_list");
    $.ajax
    ({
        type: "POST",
        enctype: 'multipart/form-data',
        url: "../../controllers/category.php",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 600000,
        async: true,
        success: function (response) 
        {
            response    =   JSON.parse(response);
            if((response["categories"]))
            {
                $.each(response["categories"], function(k, v)
                {
                    $("#category").append("<option value='"+ v["CATEGORY_ID"] +"'>" + v["CATEGORY_NAME"]  + "</option>")

                });
            }
        },
        error: function (e) 
        {
            console.log("ERROR : ", e);
            $("#NewProductFormSB").prop("disabled", false);
        }
    });

}


function NewProductFormSubmit()
{
    var form    =  $("#NewProductForm")[0];
    var data    =   new FormData(form);
    data.append("request", "add_product");
    $("#NewProductFormSB").prop("disabled", true);
    $.ajax
    ({
        type: "POST",
        enctype: 'multipart/form-data',
        url: "../../controllers/product.php",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 600000,
        async: true,
        success: function (response) 
        {
            response    =   JSON.parse(response);
            if((response["error"] == false))
            {
                alert(response["message"]);
                window.location.reload();
            }
            else
            {
                alert(response["error_msg"]);
                $("#NewProductFormSB").prop("disabled", false);
            }
            
        },
        error: function (e) 
        {
            console.log("ERROR : ", e);
            $("#NewProductFormSB").prop("disabled", false);
        }
    });
}











$(document).ready(function () 
{


    $("#NewProductForm").validate
    ({
        rules:
        {
            title:
            {
                required: true
            },
            description:
            {
                required: true
            },
            category:
            {
                required: true
            },
            price:
            {
                required: true
            },
        },
        messages:
        {
            title:
            {
                required: "Product title cannot be empty"
            },
            description:
            {
                required: "Product description is required"
            },
            category:
            {
                required: "Product category is required"
            },
            price:
            {
                required: "Product price is required"
            },
        },
    });



    $("#images").on("change", function(event)
    {
        event.preventDefault();
        var files   =   $(this).get(0).files;
        if((files))
        {
            $("#ImagesPreview").html('');
            $.each(files, function(k, v)
            {
                imgurl  =   URL.createObjectURL(v);
                $("#ImagesPreview").append('<div class="p-2"><img src="'+ imgurl +'" class="img-thumbnail" style="max-height: 70px;" /></div>');
            });
        }

    });



    $("#NewProductForm").on("submit", function(event)
    {
        event.preventDefault();
        var FS  =   $(this).valid();
        if((FS))
        {
            NewProductFormSubmit();
        }

    });







    getCategoriesList();






});