<?php


require_once('config.php');





if(($response["error"] == true))
{
    echo(json_encode($response));
}


if((!isset($_SESSION["GOLDFAYRE"])))
{
    $response["error"]          =   true;
    $response["error_msg"]      =   "An Error Occurred. You are requested to login first ";
}


if(($response["error"] == false))
{
    if((isset($_POST["request"])) && ($_POST["request"] == "new_category"))
    {
        $category   =   "";

        if((!isset($_POST["categoryname"])) || (empty($_POST["categoryname"])))
        {
            $response["error"]      =   true;
            $response["error_msg"]  =   "An Error Occurred. Category Name is required";
        }
        else
        {
            $category   =   $_POST["categoryname"];
        }


        if(($response["error"] == false))
        {
            $sql = "    SELECT M.id ID, M.category_name CATEGORY 
                        FROM category M
                        WHERE LOWER(M.category_name) = LOWER(?)";
            $stmt = $db->prepare($sql); 
            $stmt->bind_param("s", $category);
            $stmt->execute();
            $result     =   $stmt->get_result();
            $row        =   mysqli_fetch_assoc($result);
            if(($row))
            {
                $response["error"]      =   true;
                $response["error_msg"]  =   "An Error Occurred. Category with the same name is present in the system.";
            }
        }

        if(($response["error"] == false))
        {
            $sql = "INSERT INTO category(category_name) VALUES (?)";
            $stmt = $db->prepare($sql); 
            $stmt->bind_param("s", $category);
            $result     =   $stmt->execute();
            if(($result))
            {
                $response["message"]    =   "New category has been added in the system successfully.";
            }
            else
            {
                $response["error"]      =   true;
                $response["error_msg"]  =   "An Error Occurred while adding the category in the system. Please try again later";
            }
        }

        echo(json_encode($response));
    }



    if((isset($_POST["request"])) && ($_POST["request"] == "get_categories"))
    {
        $categories     =   array();
        $sql            =   "   SELECT M.id ID, M.category_name CATEGORY_NAME 
                                FROM category M
                                ORDER BY 1 DESC";
        $stmt = $db->prepare($sql); 
        $stmt->execute();
        $result     =   $stmt->get_result();
        while($row = mysqli_fetch_assoc($result))
        {
            $categories[]   =   $row;
        }
        $html   =   '';
        if((count($categories) === 0))
        {
            $html   .=   '<p>No categories found in the system.</p>';
        }
        else
        {
            $html  .=   '<div class="row" style="margin-top: 20px;">';
            $html  .=   '<div class="col-lg-12">';
            $html  .=   '<div class="card">';
            $html  .=   '<div class="card-body" style="background-color: white">';
            $html  .=   '<table id="CategoriesTable" class="table table-bordered">';
            $html  .=   '<thead>';
            $html  .=   '<tr>';
            $html  .=   '<th>SNo</th>';
            $html  .=   '<th>Category Name</th>';
            $html  .=   '<th>Operations</th>';
            $html  .=   '</tr>';
            $html  .=   '</thead>';
            $html  .=   '<tbody>';
            foreach($categories as $k => $v)
            {
                $html   .=  '<tr>';
                $html   .=  '<td><strong>'.($k + 1).'</strong></td>';
                $html   .=  '<td>'.$v["CATEGORY_NAME"].'</td>';
                $html   .=  '<td>';
                $html   .=  '<div class="d-flex flex-row bd-highlight mb-3">';
                $html   .=  '<div class="p-2 bd-highlight">';
                $html   .=  '<button id="CTDR_'.$v["ID"].'" class="btn btn-danger btn-sm">DELETE</button>';
                $html   .=  '</div>';
                $html   .=  '</div>';
                $html   .=  '</td>';
                $html   .=  '</tr>';

            }
            $html  .=   '</tbody>';
            $html  .=   '</table>';
            $html  .=   '</div>';
            $html  .=   '</div>';
            $html  .=   '</div>';
            $html  .=   '</div>';
            $response["html"]   =   $html;
        }



        echo(json_encode($response));
    }



    if((isset($_POST["request"])) && ($_POST["request"] == "get_categories_list"))
    {
        $categories     =   array();
        $sql            =   "   SELECT M.id CATEGORY_ID, M.category_name CATEGORY_NAME 
                                FROM category M
                                ORDER BY 1 DESC";
        $stmt = $db->prepare($sql); 
        $stmt->execute();
        $result     =   $stmt->get_result();
        while($row = mysqli_fetch_assoc($result))
        {
            $categories[]   =   $row;   
        }
        $response["categories"]     =   $categories;
        echo(json_encode($response));
    }











}












































?>